/*****************************************************************************
*  LPC11U6x SCT demo program
*
*  1. Use SCT0 timer to generate a center aligned PWM output signal @ SCT0_OUT0
*  2. Every time P0_3 goes high to low increase the duty cycle
*  3. Every time P0_1 goes high to low decrease the duty cycle
*  4. SCT0_OUT0 is connected to P1_19
*****************************************************************************/
#include "nxp_lpc11u6x.h"

extern void SCT0_Init(void);

int main (void)
{
  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)                    // enable clock for IOCON
                               | (1u << 31);                   // enable clock for SCT0/1

    LPC_IOCON->PIO1_19 = 0x00000082;                           // P1_19 is SCT0_OUT0

    SCT0_Init();                                               // Initialize SCT

    while (1)                                                  // loop forever
    {
        if (!(LPC_GPIO_PORT->PIN[0] & (1 << 3)) && trg1)       // P0.3 high to low?
        {
            trg1 = 0;                                          // trigger P0.3 low
            if (LPC_SCT0->MATCHREL[1].L < 9)
                LPC_SCT0->MATCHREL[1].L ++;                    // increase PWM dutycycle
        }
        else if ((LPC_GPIO_PORT->PIN[0] & (1 << 3)) && !trg1)  // P0.3 low to high?
        {
            trg1 = 1;                                          // trigger P0.3 high
        }

        if (!(LPC_GPIO_PORT->PIN[0] & (1 << 1)) && trg2)       // P0.1 high to low?
        {
            trg2 = 0;                                          // trigger P0.1 low
            if (LPC_SCT0->MATCHREL[1].L > 0)
                LPC_SCT0->MATCHREL[1].L --;                    // increase PWM dutycycle
        }
        else if ((LPC_GPIO_PORT->PIN[0] & (1 << 1)) && !trg2)  // P0.1 low to high?
        {
            trg2 = 1;                                          // trigger P0.1 high
        }
    }
}
